/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import com.google.common.base.Joiner;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeListItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class ClassDefItem {
    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){
            private SectionAnnotator classDataAnnotator = null;

            @Override
            public void annotateSection(AnnotatedBytes out) {
                this.classDataAnnotator = this.annotator.getAnnotator(8192);
                super.annotateSection(out);
            }

            @Override
            public String getItemName() {
                return "class_def_item";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int classIndex = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "class_idx = %s", TypeIdItem.getReferenceAnnotation(this.dexFile, classIndex));
                int accessFlags = this.dexFile.getBuffer().readInt(out.getCursor());
                out.annotate(4, "access_flags = 0x%x: %s", accessFlags, Joiner.on('|').join((Object[])AccessFlags.getAccessFlagsForClass(accessFlags)));
                int superclassIndex = this.dexFile.getBuffer().readOptionalUint(out.getCursor());
                out.annotate(4, "superclass_idx = %s", TypeIdItem.getOptionalReferenceAnnotation(this.dexFile, superclassIndex));
                int interfacesOffset = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "interfaces_off = %s", TypeListItem.getReferenceAnnotation(this.dexFile, interfacesOffset));
                int sourceFileIdx = this.dexFile.getBuffer().readOptionalUint(out.getCursor());
                out.annotate(4, "source_file_idx = %s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, sourceFileIdx));
                int annotationsOffset = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                if (annotationsOffset == 0) {
                    out.annotate(4, "annotations_off = annotations_directory_item[NO_OFFSET]", new Object[0]);
                } else {
                    out.annotate(4, "annotations_off = annotations_directory_item[0x%x]", annotationsOffset);
                }
                int classDataOffset = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                if (classDataOffset == 0) {
                    out.annotate(4, "class_data_off = class_data_item[NO_OFFSET]", new Object[0]);
                } else {
                    out.annotate(4, "class_data_off = class_data_item[0x%x]", classDataOffset);
                    this.addClassDataIdentity(classDataOffset, (String)this.dexFile.getTypeSection().get(classIndex));
                }
                int staticValuesOffset = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                if (staticValuesOffset == 0) {
                    out.annotate(4, "static_values_off = encoded_array_item[NO_OFFSET]", new Object[0]);
                } else {
                    out.annotate(4, "static_values_off = encoded_array_item[0x%x]", staticValuesOffset);
                }
            }

            private void addClassDataIdentity(int classDataOffset, String classType) {
                if (this.classDataAnnotator != null) {
                    this.classDataAnnotator.setItemIdentity(classDataOffset, classType);
                }
            }
        };
    }
}

